module My_RPG


  class My_CommonEvent < RPG::CommonEvent

    include Recuperer_Code
    include Module_Page

    attr_reader   :indents

    def initialize
      @id = 0
      @name = ""
      @trigger = 0
      @switch_id = 1
      @list = []

      @indents = {}
    end


    def numero
      return @id
    end

    def to_rmxp
      com = RPG::CommonEvent.new
      com.id = @id
      com.name = @name
      com.trigger = @trigger
      com.switch_id = @switch_id

      com.list = []


      #list = separer_instructions(self.instructions.clone)
      list = self.instructions

      for i in 0...list.size
        rmxp = list[i].to_rmxp
        if rmxp.is_a?(Array) == false
          com.list << rmxp
        else
          # AMELIORER CONCAT
          com.list = com.list.concat(rmxp)
        end
      end

      return com

    end


    def clone
      com = My_RPG::My_CommonEvent.new
      com.id = @id
      com.name = @name
      com.trigger = @trigger
      com.switch_id = @switch_id

      for i in 0...@list.size
        com.list[i] = @list[i].clone
      end

      return com

    end




    def recuperer_code_objet(codes)
      return recuperer_cod(codes, @list)
    end







    def recuperer_code(codes)

      # On cre la liste qui contiendra toutes les instructions
      liste_instr = []

    
      for i in 0...@list.size
        instruction = @list[i]
        # On regarde si le code de l'instruction fait partie des codes recherchs
        next if codes.include?(instruction.code) == false
        liste_instr.push([-1, 0, @id, i, instruction])
      end

      return liste_instr

    end

  
    # Renvoie le nombre d'instructions contenu dans l'EC
    def nb_instructions
      return @list.size
    end

    def instructions
      return @list
    end


    def extraire_texte
      
      instructions = recuperer_ressource3(@list, L_CODE_TEXT)

      txt = instructions.extraire_texte
      
      return txt
    end

    def position
      return self.numero
    end

    def exporter_dialogue
      #puts "Common Event #{self.numero}".just(4)
      super("COMMON EVENT", "Com Ev")
    end

    def classe
      return "Common Event"
    end

    def get_position_str(pos)
      return sprintf("[Com Ev:%d:%d]", self.numero, pos)
    end



  end


end
